import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;

class Lager {
 	private Semaphore sem = new Semaphore(2, true);
// 	Set<Integer> anwProd = new ConcurrentHashMap<Integer,Boolean>().newKeySet();
	Set<Integer> anwProd = Collections.synchronizedSet(new HashSet<Integer>());
	private static final int MANZ = 20;
	private int bilanz;
 	private int anz;
 	
	Lager(int start) {
		bilanz = start;
		System.out.println("Der Laden ist offen (Bestand = " + bilanz + ")\n");
	}

	synchronized boolean istOffen() {
		if (anz < MANZ)
			return true;
		else {
			System.out.println("\nLieber " + Thread.currentThread().getName()+
				", es ist Feierabend!");
			return false;
		}
	}

	String formZeit() {
		return java.text.DateFormat.getTimeInstance().format(new java.util.Date());
	}

	void ergaenze(int nr, int add) throws InterruptedException{
		try {
			sem.acquire();
			anwProd.add(nr);
			System.out.println("  " + Thread.currentThread().getName() + " kommt");
			for (int i = 0; i < 3; i++) {
				synchronized(this) {
					bilanz += add;
					anz++;
					System.out.println("Nr. " + anz + ":\t" + Thread.currentThread().getName() +
							" ergänzt\t" + add + "\tum " + formZeit() + " Uhr. Stand: " + bilanz +
							" (Prod: " + anwProd + ")");
				}
				Thread.sleep(500);
			}
		} finally {
			System.out.println("  " + Thread.currentThread().getName() + " geht");
			anwProd.remove(nr);
			sem.release();
		}
	}

	synchronized void liefere(int sub) {
		bilanz -= sub;
		anz++;
		System.out.println("Nr. " + anz + ":\t" + Thread.currentThread().getName() +
			" entnimmt\t" + sub + "\tum " + formZeit() + " Uhr. Stand: " + bilanz);
	}
}